#include <stdio.h>
#include <stdlib.h>

/**
 * Copy content from one file to another.
 */
void copy_file(FILE *in, FILE *out) {
    char buffer[4096];
    size_t read;
    while ((read = fread(buffer, 1, sizeof(buffer), in)) > 0) {
        fwrite(buffer, 1, read, out);
    }
}

int main(int argc, char *argv[]) {
    if (argc != 4) {
        fprintf(stderr, "Usage: %s <file1> <file2> <output_file>\n", argv[0]);
        return 1;
    }

    const char *file1 = argv[1];
    const char *file2 = argv[2];
    const char *outfile = argv[3];

    FILE *f1 = fopen(file1, "rb");
    if (!f1) {
        perror("Error opening first file");
        return 1;
    }

    FILE *f2 = fopen(file2, "rb");
    if (!f2) {
        perror("Error opening second file");
        fclose(f1);
        return 1;
    }

    FILE *fout = fopen(outfile, "wb");
    if (!fout) {
        perror("Error creating output file");
        fclose(f1);
        fclose(f2);
        return 1;
    }

    /** Copy first file */
    copy_file(f1, fout);

    /** Copy second file */
    copy_file(f2, fout);

    fclose(f1);
    fclose(f2);
    fclose(fout);

    printf("Output written to '%s'\n", outfile);
    return 0;
}
